Version 1/200616 of Under They Thunder Definitions by Andrew Schultz begins here.

"This should briefly describe the purpose of Under They Thunder Definitions."

volume general

to decide whether always-no: no.

to decide whether always-yes: no.

section relative room specifications

to say of-room of (rm - a room): if location of player is not rm, say " of [rm]"

to say in-room of (rm - a room): if location of player is not rm, say " in [rm]"

to say in-here of (rm - a room): say "[if player is in rm]here[else]in [rm][end if]"

to say here-there of (rm - a room): say " of [if player is in rm]here[else][rm][end if]"

to say once-now of (ts - a truth state): say "[if ts is true]now[else]once[end if]"

to say is-are of (nu - a number): say "[if nu is 1]is[else]are[end if]"

book directions

definition: a direction (called d) is viable:
	if player is in Ere Say Seer and d is outside, yes;
	if the room d of location of player is nowhere, no;
	if player is in Art Stay and d is down and score < 1, no; [?? again fix the conditional]
	if player is in Berth Earth Bay:
		if d is west or d is south:
			if did-east-berth is false, yes;
			no;
	yes;

book read verb

definition: a thing (called th) is now-readable:
	if th is not touchable, no;
	if th is a thing-to-read listed in table of readables, yes;
	if th is a helpbook, yes;
	no;

book talk verb

definition: a thing (called th) is npcish:
	unless th is a person, no;
	if th is the player, no;
	if th is touchable, yes;
	no;

book think verb

to decide whether thinkable of (t1 - a truth state) and (t2 - a truth state): [we have a truth state for if something appears in THINK (t1) and compare it to (t2), a flag that says, you did the action.]
	if t1 is false, no;
	if t2 is true:
		say "(trivial technical bug) I didn't properly reset variables for the THINK code. If you can email me at [email], it'd be good to know--this shouldn't affect gameplay, but it means I got slightly sloppy with coding and testing.";
		now t2 is false;
	yes;

book VERBS verb

to decide whether any-local-opts: [this will be built on]
	if player is in Breeding Reading Bay and Shelf Elf Shay is talked-to, yes;
	no;

book numbers and strings

to say between-only of (nu - a number):
	if nu is 1:
		say "only 1";
	else:
		say "1-[nu]";

to say paren-range of (nu - a number):
	if nu is 1:
		say "1";
	else:
		say "(1-[nu])";

volume by room arranged alphabetically

to decide which number is conditional-max:
	if opt-stay-stop is false, decide on the maximum score;
	decide on points-left + score;

to decide which number is points-left: [the order follows the short walkthrough]
	let temp be 1; [the final point]
	if sco-vg-clod is false, increment temp;
	if sco-use-clod-sleek is false, increment temp;
	if sco-talk-thump is false, increment temp;
	if sco-vg-boats is false, increment temp;
	if isle day dial is unvisited, increment temp;
	if sco-use-phone is false, increment temp;
	if able kay cable is off-stage:
		increment temp;
		if did-break-ray is true:
			if ray rile is unvisited, increment temp;
			if sco-use-clever is false, increment temp;
	if sco-use-cable-blower is false, increment temp;
	if isle away awhile is unvisited, increment temp;
	if sco-ankh-flank is false, increment temp;
	decide on temp;

book Actually, general chase stuff first

count-this-turn is a truth state that varies.

to decide whether in-any-chase:
	if sta-chase-b is true or sta-chase-c is true, yes;
	no;

to decide which person is cur-chaser:
	if sta-chase-b is true, decide on Chase Ace Che;
	if sta-chase-c is true, decide on Imp Prey Primp;
	say "<BUG NO CHASE-FOE DISCOVERED>";
	decide on K;

book all hay hall

to decide whether ready-final-battle:
	if final-battle-points is 2, yes;
	no;

to decide which number is final-battle-points:
	decide on boolval of sco-use-saw-slumber + boolval of sco-use-cam-fleet;

book Berth Earth Bay

to decide whether already-clod:
	if player has clod, yes;
	if player has day doll, yes;

to decide whether iffy-hurt:
	if sco-use-cliffy-cracked is true and sco-use-function-cliffy is false, yes;
	no;

book Bless Less Bay

to decide whether can-get-oil:
	if player is not in bless less bay, no;
	if player does not have ice day dice, no;
	if ice day dice is allscored, no;
	if sco-ray-roil is false, no;
	yes;

book Blown Lone Bay

to decide whether blown-guardians-gone:
	if sco-use-lit-jay is true and sco-use-slop-march is true, yes;
	no;

book Boats Oats Bay

definition: a room (called rm) is isle-no-ship:
	if rm is West Est Way or rm is Beast East Bay, yes;
	no;

definition: a room (called rm) is shippy:
	if rm is Oats Bay, yes;
	if rm is isle-no-ship, no; [these are part of the sea, but they border on Isle Tray Trial, which holds the boats]
	if map region of rm is Eee Say Sea, yes;
	no;

to decide whether can-see-ship:
	if player is in Oats Bay, yes;
	if mrlp is Eee Say Sea, yes;
	no;

book Breeding Reading Bay

definition: a helpbook (called he) is undone:
	process the finished-reading-rule of he;
	if the rule failed, yes;
	no;

definition: a helpbook (called he) is done:
	process the finished-reading-rule of he;
	if the rule succeeded, yes;
	no;

to decide which number is undone-helpbooks:
	let temp be 0;
	repeat with Q running through helpbooks:
		process the finished-reading-rule of Q;
		if the rule failed, increment temp;
	decide on temp;

to decide which number is done-helpbooks:
	let temp be 0;
	repeat with Q running through helpbooks:
		process the finished-reading-rule of Q;
		if the rule succeeded, increment temp;
	decide on temp;

book Chez F Chef

to decide which number is chef-ingredients-got:
	decide on number of moot ingredients;

to decide which number is chef-ingredients-needed:
	decide on number of not moot ingredients;

book cruddy ruddy cay

to decide whether goading-should:
	if did-talk-should is false, no;
	if sco-talk-should is true, no;
	yes;

book far are fey

to decide whether block-far-east:
	if sco-use-foil-proof is true and sco-use-proof-falter is false, yes;
	no;

book Sci I Say

to decide whether ray-needs-rile:
	if did-break-ray is true and sco-use-clever is false, yes; [ray-needs-rile]
	no;

to decide whether ray-needs-rod:
	if did-ray-ankh is true and sco-use-rod-ray is false, yes; [ray-needs-rod]
	no;

to decide whether ray-is-working:
	if did-break-ray is false and did-raid-aid-ray is true, yes; [ray-is-working]
	no;

to decide which number is got-score of (la - a latinable):
	let temp be 0;
	repeat through guess-table of la:
		if worked-yet entry is true, increment temp;
	decide on temp;

to decide which number is need-score of (la - a latinable):
	let temp be 0;
	repeat through guess-table of la:
		if can-work entry is true and worked-yet entry is false, increment temp;
	decide on temp;

to decide which number is not-guessed of (la - a latinable):
	let temp be 0;
	repeat through guess-table of la:
		if can-work entry is true and worked-yet entry is false and tried-yet entry is false, increment temp;
	decide on temp;

to decide which number is total-score of (la - a latinable):
	let temp be 0;
	repeat through guess-table of la:
		if can-work entry is true, increment temp;
	decide on temp;
	
definition: a latinable (called la) is unscored:
	if got-score of la is 0, yes;
	no;

definition: a latinable (called la) is allscored:
	if need-score of la is 0, yes;
	no;

book Sing Ing Say

to decide which number is songs-left:
	decide on number of songs in Sing Ing Say.

to decide which number is song-index of (so - a song):
	let temp be 1;
	if so is not listed in song-list:
		say "<WARNING [so] had no index>";
		decide on 1;
	while temp <= number of entries in song-list:
		if entry temp of song-list is so, decide on temp;
		increment temp;

to decide which song is next-song of (so - a song):
	let SI be song-index of so + 1;
	if SI > number of entries in song-list, now SI is 1;
	decide on entry SI of song-list;

book Start Art Stay

to decide which number is rayables: decide on number of rayable rooms.

book which say switch

to decide whether can-switch: [??whacks / wax axe way, bawl/ball all bay]
	yes;
	if bawl all bay is visited, yes;
	no;

book Wall All Way

to decide whether get-by-wall: no.

book Waste Aced Way

definition: a thing (called th) is moot:
	if th is in Aced Way, yes;
	no;

volume to decide

volume to determine

Under They Thunder Definitions ends here.

---- DOCUMENTATION ----
